/*
 * Decompiled with CFR 0.152.
 */
package com.pfg.mi1robot;

import com.pfg.mi1robot.Bitmap;
import com.pfg.mi1robot.ColorComando;
import com.pfg.mi1robot.Comandos;
import com.pfg.mi1robot.Escenario;
import com.pfg.mi1robot.Letra;
import com.pfg.mi1robot.Robot;
import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;

public class Repeat
extends Comandos {
    private ArrayList<Comandos> comandos;
    private Comandos condicion;

    public Repeat(int X, int Y, Bitmap grafico) {
        this.setNombre("Repetir");
        this.setTipo("Condicional");
        this.setX(X);
        this.setY(Y);
        this.grafico = grafico;
        this.comandos = new ArrayList();
    }

    public Comandos getCondicion() {
        return this.condicion;
    }

    public void setCondicion(Comandos comando) {
        if (comando instanceof ColorComando || comando instanceof Letra) {
            this.condicion = comando;
        }
    }

    public void setComandoenBucle(Comandos comando) {
        this.comandos.add(comando);
    }

    public void removeComandoenBucle() {
        int size = this.comandos.size();
        this.comandos.remove(size - 1);
    }

    @Override
    public void draw(Graphics g, int xcord, int ycord) {
        g.drawImage(this.grafico.getImagen(), this.getX() - xcord, this.getY() - ycord, null);
        if (this.condicion != null) {
            if (this.condicion instanceof Letra) {
                g.drawImage(this.condicion.getGrafico().getImagen(), this.getX() - xcord + this.grafico.getWidth(), this.getY() - ycord, null);
            } else if (this.condicion instanceof ColorComando) {
                Color c = new Color(((ColorComando)this.condicion).getColor());
                g.setColor(c);
                g.fillRect(this.getX() - xcord + this.grafico.getWidth(), this.getY() - ycord, 32, 32);
            }
        }
    }

    @Override
    public void exec(Robot robot, Escenario escenario) {
    }

    @Override
    public Comandos clone() {
        return new Repeat(this.getX(), this.getY(), this.grafico);
    }

    @Override
    public void loadSound() {
    }

    @Override
    public void save(BufferedWriter writer) throws IOException {
        if (this.condicion instanceof Letra) {
            writer.write("Repetir ");
            this.condicion.save(writer);
        } else {
            writer.write("Repetir " + ((ColorComando)this.condicion).stringcolor());
        }
    }
}

